/*
 * Decompiled with CFR 0.152.
 */
package com.axinom.wowza;

import com.axinom.wowza.AxinomIntegrationUtilities;
import com.wowza.util.Base64;
import com.wowza.util.BufferUtils;
import com.wowza.util.SystemUtils;
import com.wowza.wms.application.IApplicationInstance;
import com.wowza.wms.application.WMSProperties;
import com.wowza.wms.drm.cenc.CencDRMInfoPlayready;
import com.wowza.wms.drm.cenc.CencDRMInfoWidevine;
import com.wowza.wms.drm.cenc.CencInfo;
import com.wowza.wms.drm.cenc.ICencDRMInfo;
import com.wowza.wms.drm.playready.PlayReadyKeyInfo;
import com.wowza.wms.httpstreamer.cupertinostreaming.file.IHTTPStreamerCupertinoIndex;
import com.wowza.wms.httpstreamer.cupertinostreaming.httpstreamer.HTTPStreamerSessionCupertino;
import com.wowza.wms.httpstreamer.cupertinostreaming.util.CupertinoEncInfo;
import com.wowza.wms.httpstreamer.model.IHTTPStreamerSession;
import com.wowza.wms.httpstreamer.mpegdashstreaming.file.IHTTPStreamerMPEGDashIndex;
import com.wowza.wms.httpstreamer.mpegdashstreaming.httpstreamer.HTTPStreamerSessionMPEGDash;
import com.wowza.wms.module.ModuleBase;
import com.wowza.wms.stream.livepacketizer.ILiveStreamPacketizer;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.security.Key;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;

public class AxinomIntegration
extends ModuleBase {
    private Boolean configurationFailure;
    private String contentKeyIdAsBase64;
    private String contentKey;
    private String keyIdAsHex;
    private static Boolean debugMode;
    private static String streamMapFilePath;
    private static IHTTPStreamerSession globalHttpSession;
    private String fairPlaySkdUri;
    private String fairPlayIv;
    private String playReadyCheckSum;
    private String playReadyLicenseServiceUrl;
    private int widevineCencEncryptionScheme;
    private String widevineCencAlgorithm;
    private String widevineKeyServiceUrl;
    private String widevineProviderName;
    private String widevinePsshData;
    private static String widevineSigningKey;
    private static String widevineSigningIv;

    public void onAppStart(IApplicationInstance appInstance) throws Exception {
        AxinomIntegration.logAxinomMessage("Module version: " + AxinomIntegration.getModuleVersion());
        AxinomIntegration.logAxinomMessage("Module starting.");
        this.setConfigurationValues(appInstance);
        if (!this.configurationFailure.booleanValue()) {
            AxinomIntegration.logAxinomMessage("Module started successfully.");
        }
        AxinomIntegration.logAxinomDebugInfo("Debugging mode active.");
    }

    private void setConfigurationValues(IApplicationInstance appInstance) throws Exception {
        AxinomIntegration.logAxinomMessage("Loading application properties for the module.");
        this.configurationFailure = false;
        WMSProperties applicationProperties = appInstance.getProperties();
        this.contentKeyIdAsBase64 = applicationProperties.getPropertyStr("AxinomContentKeyIdAsBase64", null);
        debugMode = applicationProperties.getPropertyBoolean("AxinomDebugMode", true);
        this.playReadyLicenseServiceUrl = applicationProperties.getPropertyStr("AxinomPlayReadyLicenseUrl", null);
        this.widevineCencAlgorithm = applicationProperties.getPropertyStr("AxinomWidevineCencAlgorithm", null);
        this.widevineKeyServiceUrl = applicationProperties.getPropertyStr("AxinomKeyServiceWidevineCencApiUrl", null);
        this.widevineProviderName = applicationProperties.getPropertyStr("AxinomWidevineProviderName", null);
        widevineSigningIv = applicationProperties.getPropertyStr("AxinomWidevineSigningIv", null);
        widevineSigningKey = applicationProperties.getPropertyStr("AxinomWidevineSigningKey", null);
        HashMap<String, String> moduleHashMap = this.setSystemEnvironmentVariables(appInstance, applicationProperties);
        streamMapFilePath = SystemUtils.expandEnvironmentVariables((String)"${com.wowza.wms.context.VHostConfigHome}/conf/${com.wowza.wms.context.Application}/StreamMapFile.txt", moduleHashMap);
        try {
            this.checkApplicationConfigurationParameters();
        }
        catch (Exception ex) {
            this.configurationFailure = true;
            throw ex;
        }
    }

    private HashMap<String, String> setSystemEnvironmentVariables(IApplicationInstance appInstance, WMSProperties props) {
        HashMap<String, String> pathMap = new HashMap<String, String>();
        pathMap.put("com.wowza.wms.context.Application", appInstance.getApplication().getName());
        pathMap.put("com.wowza.wms.context.ApplicationInstance", appInstance.getName());
        pathMap.put("com.wowza.wms.context.VHost", appInstance.getVHost().getName());
        pathMap.put("com.wowza.wms.context.VHostConfigHome", appInstance.getVHost().getHomePath());
        return pathMap;
    }

    public void onHTTPSessionCreate(IHTTPStreamerSession httpSession) {
        globalHttpSession = httpSession;
    }

    public void onHTTPMPEGDashEncryptionKeyVODChunk(HTTPStreamerSessionMPEGDash httpSession, IHTTPStreamerMPEGDashIndex index, CencInfo cencInfo, long chunkId) throws Exception {
        AxinomIntegration.logAxinomMessage("Applying DASH VOD Stream encryption.");
        if (this.configurationFailure.booleanValue()) {
            AxinomIntegration.rejectLocalHttpSession(httpSession);
            throw new Exception("Axinom module error: Application configuration error!");
        }
        try {
            this.handleAxinomKeyServiceRequest(httpSession.getStreamName());
        }
        catch (Exception ex) {
            AxinomIntegration.rejectLocalHttpSession(httpSession);
            throw ex;
        }
        this.addProtectionToDashMedia(cencInfo);
        AxinomIntegration.logAxinomMessage("CENC VOD Stream encryption complete.");
    }

    public void onHTTPMPEGDashEncryptionKeyLiveChunk(ILiveStreamPacketizer liveStreamPacketizer, String streamName, CencInfo cencInfo, long chunkId) throws Exception {
        AxinomIntegration.logAxinomMessage("Applying DASH Live Stream encryption.");
        if (this.configurationFailure.booleanValue()) {
            AxinomIntegration.rejectGlobalHttpSession();
            throw new Exception("Axinom module error: Application configuration error!");
        }
        try {
            this.handleAxinomKeyServiceRequest(streamName);
        }
        catch (Exception ex) {
            AxinomIntegration.rejectGlobalHttpSession();
            throw ex;
        }
        this.addProtectionToDashMedia(cencInfo);
        AxinomIntegration.logAxinomMessage("CENC Live Stream encryption complete.");
    }

    public void addProtectionToDashMedia(CencInfo cencInfo) {
        String kid = AxinomIntegrationUtilities.bigEndianGuidHexToGuidString(this.keyIdAsHex);
        cencInfo.setAlgorithm(this.widevineCencEncryptionScheme);
        cencInfo.setKID(kid);
        cencInfo.setEncKeyBytes(Base64.decode((String)this.contentKey));
        CencDRMInfoWidevine drmInfo = new CencDRMInfoWidevine();
        drmInfo.setSystemId("edef8ba9-79d6-4ace-a3c8-27dcd51d21ed");
        drmInfo.setPsshData(Base64.decode((String)this.widevinePsshData));
        cencInfo.addDRM("widevineDRM:edef8ba9-79d6-4ace-a3c8-27dcd51d21ed", (ICencDRMInfo)drmInfo);
        PlayReadyKeyInfo playReadyKeyInfo = new PlayReadyKeyInfo();
        playReadyKeyInfo.setLicenseURL(this.playReadyLicenseServiceUrl);
        playReadyKeyInfo.setChecksum(Base64.decode((String)this.playReadyCheckSum));
        playReadyKeyInfo.setKeyId(BufferUtils.decodeHexString((String)this.keyIdAsHex.replace("-", "")));
        playReadyKeyInfo.setContentKey(Base64.decode((String)this.contentKey));
        CencDRMInfoPlayready prInfo = new CencDRMInfoPlayready();
        prInfo.setPlayReadyKeyInfo(playReadyKeyInfo);
        cencInfo.addDRM("playReadyDRM:9a04f079-9840-4286-ab92-e65be0885f95", (ICencDRMInfo)prInfo);
    }

    public void onHTTPCupertinoEncryptionKeyVODChunk(HTTPStreamerSessionCupertino httpSession, IHTTPStreamerCupertinoIndex index, CupertinoEncInfo encInfo, long chunkId, int mode) throws Exception {
        AxinomIntegration.logAxinomMessage("Applying HLS VOD Stream encryption.");
        if (this.configurationFailure.booleanValue()) {
            AxinomIntegration.rejectLocalFpHttpSession(httpSession);
            throw new Exception("Axinom module error: Application configuration error!");
        }
        int encryptionMethod = encInfo.getEncMethod();
        if (encryptionMethod == 0) {
            try {
                this.handleAxinomKeyServiceRequest(httpSession.getStreamName());
            }
            catch (Exception ex) {
                AxinomIntegration.logAxinomError(ex.getMessage());
                AxinomIntegration.rejectLocalFpHttpSession(httpSession);
                throw ex;
            }
        }
        this.addProtectionToHlsMedia(encInfo);
        AxinomIntegration.logAxinomMessage("HLS VOD Stream encryption complete.");
    }

    public void onHTTPCupertinoEncryptionKeyLiveChunk(ILiveStreamPacketizer liveStreamPacketizer, String streamName, CupertinoEncInfo encInfo, long chunkId, int mode) throws Exception {
        AxinomIntegration.logAxinomMessage("Applying HLS Live Stream encryption.");
        if (this.configurationFailure.booleanValue()) {
            AxinomIntegration.rejectGlobalHttpSession();
            throw new Exception("Axinom module error: Application configuration error!");
        }
        try {
            this.handleAxinomKeyServiceRequest(streamName);
        }
        catch (Exception ex) {
            AxinomIntegration.rejectGlobalHttpSession();
            throw ex;
        }
        this.addProtectionToHlsMedia(encInfo);
        AxinomIntegration.logAxinomMessage("HLS Live Stream encryption complete.");
    }

    private void addProtectionToHlsMedia(CupertinoEncInfo encInfo) {
        encInfo.setEncMethod(2);
        encInfo.setEncUrl(this.fairPlaySkdUri);
        encInfo.setEncKeyBytes(Base64.decode((String)this.contentKey));
        encInfo.setEncIVBytes(BufferUtils.decodeHexString((String)this.fairPlayIv));
        encInfo.setEncIVBytesInChunklist(false);
        encInfo.setEncKeyFormat("com.apple.streamingkeydelivery");
        encInfo.setEncKeyFormatVersion("1");
    }

    private void checkApplicationConfigurationParameters() throws Exception {
        if (this.widevineCencAlgorithm == null || this.widevineCencAlgorithm.equalsIgnoreCase("CTR")) {
            this.widevineCencEncryptionScheme = 1;
        } else if (this.widevineCencAlgorithm.equalsIgnoreCase("CBCS")) {
            this.widevineCencEncryptionScheme = 2;
        } else {
            AxinomIntegration.logAxinomError("Invalid CENC encryption scheme (AxinomWidevineCencAlgorithm) provided in application properties.");
            throw new Exception();
        }
        if (this.playReadyLicenseServiceUrl == null || !AxinomIntegrationUtilities.isUrlFormatValid(this.playReadyLicenseServiceUrl)) {
            AxinomIntegration.logAxinomError("Axinom PlayReady License Service URL (AxinomPlayReadyLicenseUrl) missing or in an invalid format in application properties.");
            throw new Exception();
        }
        if (this.widevineKeyServiceUrl == null || !AxinomIntegrationUtilities.isUrlFormatValid(this.widevineKeyServiceUrl)) {
            AxinomIntegration.logAxinomError("Widevine Key Service URL (AxinomKeyServiceWidevineCencApiUrl) missing or in an invalid format in application properties.");
            throw new Exception();
        }
        if (this.widevineProviderName == null || this.widevineProviderName == "") {
            AxinomIntegration.logAxinomError("Widevine provider name (AxinomWidevineProviderName) missing in application properties.");
            throw new Exception();
        }
        if (widevineSigningIv == null || widevineSigningIv == "") {
            AxinomIntegration.logAxinomError("Widevine Signing IV (AxinomWidevineSigningIv) missing in application properties.");
            throw new Exception();
        }
        if (widevineSigningKey == null || widevineSigningKey == "") {
            AxinomIntegration.logAxinomError("Widevine Signing IV (AxinomWidevineSigningKey) missing in application properties.");
            throw new Exception();
        }
    }

    private static String checkForExistingStreamMapFileForValues(String mediaName) throws Exception {
        AxinomIntegration.logAxinomMessage("Checking stream map file for existing values.");
        String contentKeyId = null;
        File keyMapFile = new File(streamMapFilePath);
        if (keyMapFile.exists()) {
            AxinomIntegration.logAxinomMessage("Existing stream map file found.");
            try {
                contentKeyId = AxinomIntegration.getContentKeyIdFromStreamMapFile(mediaName);
                return contentKeyId;
            }
            catch (Exception ex) {
                AxinomIntegration.logAxinomError("Exception thrown while reading stream map file.");
                throw ex;
            }
        }
        AxinomIntegration.logAxinomMessage("No existing stream map file found.");
        return null;
    }

    private static String createNewKeyIdAndUuidPair(String mediaName) throws Exception {
        AxinomIntegration.logAxinomMessage("Creating new stream map file.");
        File file = new File("${com.wowza.wms.context.VHostConfigHome}" + File.separator + "conf" + File.separator + "${com.wowza.wms.context.Application}" + File.separator, "StreamMapFile.txt");
        String newcontentId = AxinomIntegration.writeNewKeyIdWithRandomUuidPairToStreamMapFile(mediaName);
        return newcontentId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String getContentKeyIdFromStreamMapFile(String mediaName) throws Exception {
        AxinomIntegration.logAxinomMessage("Reading stream map file.");
        String delimiter = ":";
        Throwable throwable = null;
        Object var3_4 = null;
        try (BufferedReader bufferedReader = new BufferedReader(new FileReader(streamMapFilePath));){
            String contentKeyIdFromStreamMapFile;
            String streamNameFromStreamMapFile;
            while (true) {
                int position;
                String currentLineInFile;
                if ((currentLineInFile = bufferedReader.readLine()) == null) {
                    return null;
                }
                if ((currentLineInFile = currentLineInFile.trim()).length() == 0 || (position = currentLineInFile.indexOf(delimiter)) < 0) continue;
                streamNameFromStreamMapFile = currentLineInFile.substring(0, position).trim();
                contentKeyIdFromStreamMapFile = currentLineInFile.substring(position + 1).trim();
                if (streamNameFromStreamMapFile.contentEquals(mediaName)) break;
            }
            AxinomIntegration.logAxinomMessage("Stream name found from stream map file- " + streamNameFromStreamMapFile);
            AxinomIntegration.logAxinomMessage("Connected stream content key id found from stream map file- " + contentKeyIdFromStreamMapFile);
            return AxinomIntegrationUtilities.stringToBase64(contentKeyIdFromStreamMapFile);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
                throw throwable;
            }
            if (throwable == throwable2) throw throwable;
            throwable.addSuppressed(throwable2);
            throw throwable;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String writeNewKeyIdWithRandomUuidPairToStreamMapFile(String mediaName) throws Exception {
        AxinomIntegration.logAxinomDebugInfo("Creating new key value to stream map file.");
        String newKeyId = UUID.randomUUID().toString();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try {
                FileWriter streamMapFileWriter = new FileWriter(streamMapFilePath, true);
                try {
                    block20: {
                        BufferedWriter streamMapFileBufferedWriter = new BufferedWriter(streamMapFileWriter);
                        try {
                            try (PrintWriter out = new PrintWriter(streamMapFileBufferedWriter);){
                                out.println("");
                                out.print(String.valueOf(mediaName) + ":" + newKeyId);
                            }
                            if (streamMapFileBufferedWriter == null) break block20;
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            if (streamMapFileBufferedWriter == null) throw throwable;
                            streamMapFileBufferedWriter.close();
                            throw throwable;
                        }
                        streamMapFileBufferedWriter.close();
                    }
                    if (streamMapFileWriter == null) return newKeyId;
                }
                catch (Throwable throwable3) {
                    if (throwable == null) {
                        throwable = throwable3;
                    } else if (throwable != throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    if (streamMapFileWriter == null) throw throwable;
                    streamMapFileWriter.close();
                    throw throwable;
                }
                streamMapFileWriter.close();
                return newKeyId;
            }
            catch (Throwable throwable4) {
                if (throwable == null) {
                    throwable = throwable4;
                    throw throwable;
                }
                if (throwable == throwable4) throw throwable;
                throwable.addSuppressed(throwable4);
                throw throwable;
            }
        }
        catch (Exception ex) {
            AxinomIntegration.logAxinomError("Exception thrown while trying to write new key value to stream map file.");
            throw ex;
        }
    }

    private void handleAxinomKeyServiceRequest(String streamName) throws Exception {
        AxinomIntegration.logAxinomDebugInfo("Current stream name - " + streamName);
        try {
            String contentId = null;
            if (this.contentKeyIdAsBase64 == null) {
                contentId = AxinomIntegration.checkForExistingStreamMapFileForValues(streamName);
                if (contentId == null) {
                    this.keyIdAsHex = AxinomIntegration.createNewKeyIdAndUuidPair(streamName);
                }
            } else {
                contentId = this.contentKeyIdAsBase64;
            }
            this.requestContentKeyInfoFromAxinomKeyService(contentId);
        }
        catch (Exception ex) {
            AxinomIntegration.logAxinomError("Exception thrown when creating and processing Key Service request.");
            throw ex;
        }
    }

    private void requestContentKeyInfoFromAxinomKeyService(String contentId) throws Exception {
        AxinomIntegration.logAxinomMessage("Creating Axinom Key Service POST request.");
        try {
            String keyServiceRequestJsonAsString = "{\"content_id\": \"" + contentId + "\",\"tracks\": [{\"type\": \"SD\"}],\"drm_types\": [ \"PLAYREADY\", \"WIDEVINE\", \"FAIRPLAY\" ]}";
            String widevineKeyServiceRequestAsBase64 = AxinomIntegrationUtilities.stringToBase64(keyServiceRequestJsonAsString);
            String signatureAsBase64 = AxinomIntegration.createSha1SignatureForWidevineKeyServiceRequest(contentId, keyServiceRequestJsonAsString);
            String requestBody = "{\"request\":\"" + widevineKeyServiceRequestAsBase64 + "\",\"signature\":\"" + signatureAsBase64 + "\",\"signer\":\"" + this.widevineProviderName + "\"}";
            AxinomIntegration.logAxinomMessage("Sending Axinom Key Service POST request.");
            AxinomIntegration.logAxinomDebugInfo(requestBody);
            String responseBody = "";
            try {
                CloseableHttpClient httpClient = HttpClientBuilder.create().build();
                HttpPost request = new HttpPost(this.widevineKeyServiceUrl);
                StringEntity params = new StringEntity(requestBody, "UTF-8");
                request.addHeader("content-type", "application/json");
                request.setEntity((HttpEntity)params);
                HttpResponse response = httpClient.execute((HttpUriRequest)request);
                if (!response.toString().contains("200 OK")) {
                    AxinomIntegration.logAxinomError("Failed Axinom Key Service response received.");
                    AxinomIntegration.logAxinomDebugInfo(response.toString());
                    throw new Exception();
                }
                AxinomIntegration.logAxinomMessage(response.toString());
                HttpEntity entity = response.getEntity();
                responseBody = EntityUtils.toString((HttpEntity)entity).replace("{\"response\":\"", "").replace("\"}", "");
                AxinomIntegration.logAxinomDebugInfo(responseBody);
            }
            catch (Exception ex) {
                AxinomIntegration.logAxinomError("Error occurred while sending and handling Axinom Key Service request and response.");
                throw ex;
            }
            AxinomIntegration.logAxinomMessage("Received Axinom Key Service response.");
            byte[] responseBodyAsBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)responseBody);
            String responseBodyDecoded = new String(responseBodyAsBytes, "UTF-8");
            String[] responseBodyDecodedAndSplit = responseBodyDecoded.split(",");
            boolean widevineFlag = false;
            String[] stringArray = responseBodyDecodedAndSplit;
            int n = responseBodyDecodedAndSplit.length;
            int n2 = 0;
            while (n2 < n) {
                String splitJsonAsString = stringArray[n2];
                if (splitJsonAsString.contains("checksum")) {
                    this.playReadyCheckSum = AxinomIntegrationUtilities.removeJsonBracketsAndSeparators(splitJsonAsString.split(":")[1]);
                    AxinomIntegration.logAxinomDebugInfo("Received PlayReady CheckSum- " + this.playReadyCheckSum);
                }
                if (splitJsonAsString.contains("\"key\"")) {
                    this.contentKey = AxinomIntegrationUtilities.removeJsonBracketsAndSeparators(splitJsonAsString.split(":")[1]);
                    AxinomIntegration.logAxinomDebugInfo("Received content key- " + this.contentKey);
                }
                if (splitJsonAsString.contains("key_id")) {
                    String keyIdAsBase64 = AxinomIntegrationUtilities.removeJsonBracketsAndSeparators(splitJsonAsString.split(":")[1]);
                    byte[] keyIdAsBytes = org.apache.commons.codec.binary.Base64.decodeBase64((String)keyIdAsBase64);
                    this.keyIdAsHex = Hex.encodeHexString((byte[])keyIdAsBytes);
                    AxinomIntegration.logAxinomDebugInfo("Received key ID- " + this.keyIdAsHex);
                }
                if (splitJsonAsString.contains("drm_type") && splitJsonAsString.contains("WIDEVINE")) {
                    widevineFlag = true;
                }
                if (widevineFlag && splitJsonAsString.contains("\"data\"")) {
                    this.widevinePsshData = AxinomIntegrationUtilities.removeJsonBracketsAndSeparators(splitJsonAsString.split(":")[1]);
                    AxinomIntegration.logAxinomDebugInfo("Received Widevine PSSH- " + this.widevinePsshData);
                    widevineFlag = false;
                }
                if (splitJsonAsString.contains("skd_uri")) {
                    this.fairPlaySkdUri = AxinomIntegrationUtilities.removeJsonBracketsAndSeparators(splitJsonAsString.split("\":")[1]);
                    AxinomIntegration.logAxinomDebugInfo("Received FairPlay skd_uri- " + this.fairPlaySkdUri);
                    this.fairPlayIv = this.fairPlaySkdUri.split(":")[2];
                    AxinomIntegration.logAxinomDebugInfo("Received FairPlay IV- " + this.fairPlayIv);
                }
                ++n2;
            }
        }
        catch (Exception ex) {
            AxinomIntegration.logAxinomError("Exception thrown while creating and processing Key Service request.");
            throw ex;
        }
    }

    private static String createSha1SignatureForWidevineKeyServiceRequest(String contentId, String keyServiceRequestJson) throws Exception {
        AxinomIntegration.logAxinomMessage("Creating SHA1 signature for Widevine Key Service Request.");
        try {
            byte[] widevineRequestAsByteArray = keyServiceRequestJson.getBytes("UTF-8");
            MessageDigest messageDigestSha = MessageDigest.getInstance("SHA-1");
            byte[] signatureHash = messageDigestSha.digest(widevineRequestAsByteArray);
            byte[] signingIvAsByteArray = org.apache.commons.codec.binary.Base64.decodeBase64((String)AxinomIntegrationUtilities.hexToBase64(widevineSigningIv));
            IvParameterSpec ivParameterSpec = new IvParameterSpec(signingIvAsByteArray);
            byte[] signingKeyAsByteArray = org.apache.commons.codec.binary.Base64.decodeBase64((String)AxinomIntegrationUtilities.hexToBase64(widevineSigningKey));
            SecretKeySpec signingKeySpec = new SecretKeySpec(signingKeyAsByteArray, "AES");
            Cipher cipher = Cipher.getInstance("AES/CBC/PKCS5Padding");
            cipher.init(1, (Key)signingKeySpec, ivParameterSpec);
            byte[] encryptedSha1Signature = cipher.doFinal(signatureHash);
            return org.apache.commons.codec.binary.Base64.encodeBase64String((byte[])encryptedSha1Signature);
        }
        catch (Exception ex) {
            AxinomIntegration.logAxinomError("Error occurred while creating SHA1 signature for Widevine Key Service Request.");
            throw ex;
        }
    }

    private static void rejectLocalHttpSession(HTTPStreamerSessionMPEGDash httpSession) {
        AxinomIntegration.logAxinomError("Session rejected. Check the access log for more information.");
        httpSession.rejectSession();
        httpSession.shutdown();
    }

    private static void rejectLocalFpHttpSession(HTTPStreamerSessionCupertino httpSession) {
        AxinomIntegration.logAxinomError("Session rejected. Check the access log for more information.");
        httpSession.rejectSession();
        httpSession.shutdown();
    }

    private static void rejectGlobalHttpSession() {
        AxinomIntegration.logAxinomError("Session rejected. Check the access log for more information.");
        globalHttpSession.rejectSession();
        globalHttpSession.shutdown();
    }

    private static void logAxinomMessage(String logMessage) {
        AxinomIntegration.getLogger().info("Axinom module message: " + logMessage);
    }

    private static void logAxinomError(String errorMessage) {
        AxinomIntegration.getLogger().error("Axinom module error: " + errorMessage);
    }

    private static void logAxinomDebugInfo(String debugInfo) {
        if (debugMode.booleanValue()) {
            AxinomIntegration.getLogger().info("Axinom module debug info: " + debugInfo);
        }
    }

    private static String getModuleVersion() {
        return String.format("%d.%d.%d", 1, 0, 1);
    }
}

